﻿/*
	VERSION:	1.3
	
	USAGE:
	my_sprite = makeRpgSprite( spriteLayer_mc, map_mc, "misty_walk" );										// minimum usage
	my_sprite = makeRpgSprite( spriteLayer_mc, map_mc, "misty_walk", 0, 0, 42, 1, "my_sprite" );		// maximum usage
	
	NOTE:
	If no map is supplied, no collision can occur.
	
	PUBLIC FUNCTIONS:
	move("right")		// Tells the sprite which way to walk.
*/



makeRpgSprite = function( destination, map, pose, x, y, layer, walkSpeed, spriteName)
{
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// DEFAULT SETTINGS FOR OPTIONAL PARAMETERS
	x = (x != undefined) ? x : 0;						// default: 0
	y = (y != undefined) ? y : 0;						// default: 0
	tileSize = (map.tileSize) ? map.tileSize : 16;	// default: 16
	layer = (layer != undefined) ? layer : 1;		// default: 1
	spriteName = (spriteName) ? spriteName : "sprite_"+Math.floor(Math.random()*99999);		// default:  sprite_97632
	walkSpeed = (walkSpeed > 0  &&  walkSpeed < tileSize) ? walkSpeed : (tileSize / 4);		// default:  (tileSize / 4)
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// CREATE
	var _this = destination.createEmptyMovieClip( spriteName, layer );
	#include "MakeSprite.as"
	makeSprite( 	_this, 		pose, 		"image_mc", 	0, 			24, 				32, 				3, 						4, 					1, 						1, 						2 );
//	makeSprite( 	target, 		image, 		newName, 		depth, 	spriteWidth, 	spriteHeight, 	maxAnimFrames, 	maxDirections, maxPoseColumns, maxPoseRows, 	animSpeed )
	_this.image_mc._x = 8;
	_this.image_mc._y = 8;
	_this.image_mc.setAnim(false);
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// INITIALIZE
	_this.map = map;
	_this._x = x * tileSize;
	_this._y = y * tileSize;
	_this.tileSize = tileSize;
	_this.moveDirection = "";
	_this.walkSpeed = walkSpeed;
	//_this.isMoving = false;
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// SUPPORT FUNCTIONS
	
	_this.moveSprite = function()
	{
		// initialize
		_this.x = (_this.x) ? _this.x : 0;		// default = 0		These are the relative distance that this sprite will move.
		_this.y = (_this.y) ? _this.y : 0;		// default = 0		They determine the destination, relative to the sprite's current location.
		var walkSpeed = _this.tileSize / 4;		// The 4 represents how many frames it takes to move 1 tile.
		_this.isMoving = (_this.isMoving != undefined) ? _this.isMoving : false;			// default = false
		
		
		
		
		// Not Moving
		if (!_this.isMoving)
		{
			_this.x = 0;
			_this.y = 0;
			_this.xDestination = _this._x;
			_this.yDestination = _this._y;
			_this.image_mc.setAnim(false);
			
			// select movement
			if (_this.moveDirection == "left")
			{
				_this.x -= _this.tileSize;
				_this.image_mc.setDirection("left");
			}else if (_this.moveDirection == "right")
			{
				_this.x += _this.tileSize;
				_this.image_mc.setDirection("right");
			}else if (_this.moveDirection == "up")
			{
				_this.y -= _this.tileSize;
				_this.image_mc.setDirection("up");
			}else if (_this.moveDirection == "down")
			{
				_this.y += _this.tileSize;
				_this.image_mc.setDirection("down");
			}// if: Key
			
			
			// relative coordinates  ->  absolute coordinates
			if (_this.x != 0  ||  _this.y != 0)
			{	
				// apply collision
				_this.xDestination = _this._x + _this.x;		// intended pixel coordinates
				_this.yDestination = _this._y + _this.y;
				var collide = _this.map.getPixelCollision( _this.xDestination, _this.yDestination );
				if (collide > 0)
				{	// block movement
					_this.x = 0;
					_this.y = 0;
					_this.xDestination = _this._x;		// reset these too, just for the heck of it.
					_this.yDestination = _this._y;
				}// if: collide > 0
			}// if: trying to move
			
			if (_this.x != 0  ||  _this.y != 0)
			{	
				// initiate movement
				_this.isMoving = true;
				_this.image_mc.setAnim(true);
			}// if: trying to move
		}// if: isMoving == false
	
	
	
	
	
		// Is Moving
		if (_this.isMoving)
		{
			var xDirection = _this.x / Math.abs(_this.x);		// +1 or -1
			var yDirection = _this.y / Math.abs(_this.y);		// +1 or -1
			_this._x += xDirection * walkSpeed;
			_this._y += yDirection * walkSpeed;
			// check whether movement is finished
			var xDiff = Math.abs(_this._x - _this.xDestination);
			var yDiff = Math.abs(_this._y - _this.yDestination);
			var threshold = 1;		// If the player is within 1 pixel of the destination, assume they're AT the destination.
			if (xDiff < threshold  &&  yDiff < threshold )
			{
				// adjusts position to ensure coordinate accuracy.
				_this._x = _this.xDestination;
				_this._y = _this.yDestination;
				// enable player control again
				_this.isMoving = false;
			}// if:  _x, _y are close enough to the destination
		}// if: isMoving
		
		_this.moveDirection = "";
	}// moveSprite()
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// PUBLIC FUNCTIONS
	
	_this.move = function( direction ) 
	{
		// select movement
		if (direction == 3  ||  direction == "left")
		{
			_this.moveDirection = "left";
		}else if (direction == 3  ||  direction == "right")
		{
			_this.moveDirection = "right";
		}else if (direction == 3  ||  direction == "up")
		{
			_this.moveDirection = "up";
		}else if (direction == 3  ||  direction == "down")
		{
			_this.moveDirection = "down";
		}else{
			_this.moveDirection = "";
		}// if: Key
	}// move()
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// MAIN LOOP
	
	_this.onEnterFrame = function()
	{
		_this.moveSprite();
	}// onEnterFrame()
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// OUTPUT
	return _this;		// Return a reference to this RpgSprite movieClip
	
}// makeRpgSprite()
